async function loadModules(){const e=["./lib/core/RendererCore.js","./lib/core/MessageHandler.js","./lib/core/EventManager.js","./lib/processors/MarkdownProcessor.js","./lib/processors/LatexProcessor.js","./lib/processors/MermaidProcessor.js","./lib/generators/PDFGenerator.js","./lib/generators/WordGenerator-v3.js","./lib/utils/StyleManager.js","./lib/utils/ResourceLoader.js"];for(const r of e)try{await loadScript(r)}catch(e){console.error(`[Renderer] 加载模块失败: ${r}`,e)}}function loadScript(e){return new Promise((r,n)=>{const s=document.createElement("script"),o="v="+Date.now();s.src=e+(e.includes("?")?"&":"?")+o,s.onload=r,s.onerror=n,document.head.appendChild(s)})}class IsolatedRenderer{constructor(){this.rendererCore=null,this.messageHandler=null,this.eventManager=null,this.markdownProcessor=null,this.latexProcessor=null,this.mermaidProcessor=null,this.pdfGenerator=null,this.wordGenerator=null,this.styleManager=null,this.resourceLoader=null,this.isInitialized=!1}async init(){try{await loadModules(),this.rendererCore=new window.RendererCore,await this.rendererCore.init(),this.messageHandler=new window.MessageHandler(this),this.messageHandler.init(),this.eventManager=new window.EventManager(this.rendererCore,this.messageHandler),this.eventManager.init(),this.markdownProcessor=new window.MarkdownProcessor(this.rendererCore),this.latexProcessor=new window.LatexProcessor(this.rendererCore),this.mermaidProcessor=new window.MermaidRendererProcessor(this.rendererCore),this.pdfGenerator=new window.PDFGenerator(this.rendererCore,this.messageHandler),this.wordGenerator=new window.WordGenerator(this.rendererCore,this.messageHandler),this.styleManager=new window.StyleManager(this.rendererCore),this.resourceLoader=new window.ResourceLoader(this.rendererCore),this.isInitialized=!0}catch(e){console.error("[Renderer] 初始化失败:",e),this.messageHandler?.sendMessage("initError",{error:e.message,stack:e.stack})}}async handleRender(e){let r,n,s={};if(e&&e.data&&"object"==typeof e.data){const o=e.data;({markdown:r,options:s={},requestId:n}=o),console.log("[Renderer] 使用嵌套数据结构")}else({markdown:r,options:s={},requestId:n}=e||{});if(!r)throw new Error("缺少markdown内容");try{this.rendererCore.clearContainer();const e=this.rendererCore.getRenderOptions(s);this.styleManager.applyStyles(e);const o=await this.markdownProcessor.processMarkdownUnified(r,e,n);this.rendererCore.container.innerHTML=o,await this.resourceLoader.waitForResourcesLoaded(),this.rendererCore.pendingMermaidBlocks&&this.rendererCore.pendingMermaidBlocks.length>0&&await this.mermaidProcessor.renderMermaidCharts(this.rendererCore.container),await this.latexProcessor.renderLatexFormulas(this.rendererCore.container),await this.initTextAnchorSync(),this.messageHandler.sendMessage("renderComplete",{success:!0,requestId:n,stats:this.rendererCore.getConversionStats()})}catch(e){console.error("[Renderer] 渲染失败:",e),this.messageHandler.sendMessage("renderError",{error:e.message,requestId:n,stack:e.stack})}}async renderContentOnly(e){const{markdown:r,options:n={},requestId:s}=e;if(!r)throw new Error("renderContentOnly: 缺少markdown内容");this.rendererCore.clearContainer();const o=this.rendererCore.getRenderOptions(n);this.styleManager.applyStyles(o);const t=await this.markdownProcessor.processMarkdownUnified(r,o,s);this.rendererCore.container.innerHTML=t,await this.resourceLoader.waitForResourcesLoaded(),this.rendererCore.pendingMermaidBlocks&&this.rendererCore.pendingMermaidBlocks.length>0&&await this.mermaidProcessor.renderMermaidCharts(this.rendererCore.container),await this.latexProcessor.renderLatexFormulas(this.rendererCore.container)}async handleRenderPreview(e){const{data:r}=e||{},{markdown:n,options:s={},requestId:o}=r||{};if(n)try{this.rendererCore.clearContainer();const e=this.rendererCore.getRenderOptions(s);this.styleManager.applyStyles(e);const r=await this.markdownProcessor.processMarkdownUnified(n,e,o);this.rendererCore.container.innerHTML=r,this.rendererCore.pendingMermaidBlocks&&this.rendererCore.pendingMermaidBlocks.length>0&&await this.mermaidProcessor.renderMermaidCharts(this.rendererCore.container,!0),await this.latexProcessor.renderLatexFormulas(this.rendererCore.container,!0),await new Promise(e=>setTimeout(e,100)),this.messageHandler.sendMessage("renderComplete",{success:!0,requestId:o,result:{html:this.rendererCore.container.innerHTML,stats:this.rendererCore.getConversionStats()}})}catch(e){console.error("[Renderer] 预览渲染失败:",e),this.messageHandler.sendMessage("renderComplete",{success:!1,error:e.message,requestId:o})}else this.messageHandler.sendMessage("renderComplete",{success:!1,error:"缺少markdown内容",requestId:o})}async generatePDF(e,r){const{markdown:n,filename:s,options:o={}}=e;try{if(!n)throw new Error("generatePDF: markdown参数为空");if(!(this.rendererCore.container&&this.rendererCore.container.innerHTML.length>0))try{await this.renderContentOnly({markdown:n,options:o,requestId:r})}catch(e){throw console.error("[Renderer] renderContentOnly执行失败:",e),console.error("[Renderer] 错误详情:",{message:e.message,stack:e.stack,"markdown长度":n?.length}),new Error(`渲染失败: ${e.message}`)}const e=this.rendererCore.container.innerHTML.length;this.rendererCore.container.scrollHeight;if(0===e)throw new Error("容器中没有渲染内容");await new Promise(e=>setTimeout(e,500));const t={filename:s,options:o};return await this.pdfGenerator.generatePDF(t,r)}catch(e){throw console.error("[Renderer] PDF生成失败:",e),console.error("[Renderer] 完整错误:",e.stack),e}}async generateWord(e,r){const{markdown:n,filename:s,options:o={}}=e;try{return await this.handleRender({markdown:n,options:o,requestId:r}),await new Promise(e=>setTimeout(e,500)),await this.wordGenerator.generateWord({options:o,filename:s,requestId:r})}catch(e){throw console.error("[Renderer] Word生成失败:",e),e}}async previewOnly(e){const{options:r={},requestId:n}=e||{};try{this.messageHandler.sendMessage("renderComplete",{success:!0,requestId:n,stats:this.rendererCore.getConversionStats()})}catch(e){console.error("[Renderer] 预览失败:",e),this.messageHandler.sendMessage("renderError",{error:e.message,requestId:n})}}async initTextAnchorSync(){if(window.TextAnchorScrollSync){new window.TextAnchorScrollSync({container:this.rendererCore.container,onReady:()=>{let e=0;setTimeout(()=>{0===e&&this.messageHandler.sendMessage("textAnchorSyncReady"),e++},100)}}).initialize()}}clearRenderCache(){this.rendererCore.clearRenderCache()}destroy(){this.eventManager&&this.eventManager.destroy(),this.messageHandler&&this.messageHandler.destroy(),this.rendererCore&&this.rendererCore.destroy()}}let renderer;document.addEventListener("DOMContentLoaded",async()=>{try{renderer=new IsolatedRenderer,await renderer.init();const e={source:"md2pdf-renderer",type:"ready",timestamp:Date.now()};window.parent&&window.parent!==window?window.parent.postMessage(e,"*"):window.opener?window.opener.postMessage(e,"*"):console.warn("[Renderer] 无法发送ready消息，未检测到父窗口")}catch(e){console.error("[Renderer] 渲染器初始化失败:",e);try{const r={source:"md2pdf-renderer",action:"initError",data:{error:e.message},timestamp:Date.now()};window.opener?(console.log("[Renderer] 发送初始化错误给opener窗口"),window.opener.postMessage(r,"*")):window.parent&&window.parent!==window?(console.log("[Renderer] 发送初始化错误给parent窗口"),window.parent.postMessage(r,"*")):console.warn("[Renderer] 无法发送初始化错误消息")}catch(e){console.error("[Renderer] 发送初始化错误消息失败:",e)}}}),window.addEventListener("beforeunload",()=>{renderer&&renderer.destroy()});