class StyleManager{constructor(n){this.rendererCore=n}applyStyles(n){const e=this.generateStyles(n);this.rendererCore.customStyleElement||(this.rendererCore.customStyleElement=document.createElement("style"),this.rendererCore.shadowRoot.appendChild(this.rendererCore.customStyleElement)),this.rendererCore.customStyleElement.textContent=e}generateStyles(n){const{pageSize:e="a4",scale:r=2}=n;return`\n      /* 确保body没有margin */\n      body {\n        margin: 0 !important;\n        padding: 0 !important;\n      }\n      \n      /* 基础样式 - 固定容器尺寸避免溢出 */\n      #shadow-render-container {\n        width: ${this.rendererCore.config.container.width}px;\n        max-width: ${this.rendererCore.config.container.width}px;\n        min-height: ${this.rendererCore.config.container.height}px;\n        margin: 0 !important;  /* 强制移除所有margin */\n        position: relative;  /* 确保定位上下文 */\n        left: 0 !important;  /* 确保左对齐 */\n        background: ${n.backgroundColor||"#ffffff"};\n        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;\n        font-size: 14px;\n        line-height: 1.6;\n        color: #333;\n        padding: ${this.rendererCore.config.container.padding}px;\n        box-sizing: border-box;\n        overflow: hidden; /* 防止内容溢出 */\n        word-wrap: break-word; /* 长单词换行 */\n      }\n      \n      /* 标题样式 - 使用固定字体大小 */\n      #shadow-render-container h1, #shadow-render-container h2, #shadow-render-container h3,\n      #shadow-render-container h4, #shadow-render-container h5, #shadow-render-container h6 {\n        margin-top: 24px;\n        margin-bottom: 16px;\n        font-weight: 600;\n        line-height: 1.25;\n        word-wrap: break-word;\n      }\n      \n      #shadow-render-container h1 { font-size: 28px; }\n      #shadow-render-container h2 { font-size: 24px; }\n      #shadow-render-container h3 { font-size: 20px; }\n      \n      /* 段落样式 */\n      #shadow-render-container p {\n        margin-bottom: 16px;\n        line-height: 1.6;\n      }\n      \n      /* 代码样式 - 固定字体大小 */\n      #shadow-render-container pre {\n        background: #f6f8fa;\n        border-radius: 6px;\n        padding: 16px;\n        overflow: auto;\n        font-size: 13px;\n        line-height: 1.45;\n        word-wrap: break-word;\n        white-space: pre-wrap;\n      }\n      \n      #shadow-render-container code {\n        background: #f6f8fa;\n        border-radius: 3px;\n        padding: 2px 4px;\n        font-size: 13px;\n      }\n      \n      /* 表格样式 */\n      #shadow-render-container table {\n        border-collapse: collapse;\n        width: 100%;\n        max-width: 100%;\n        margin: 16px 0;\n        table-layout: fixed; /* 防止表格溢出 */\n      }\n      \n      #shadow-render-container th, #shadow-render-container td {\n        border: 1px solid #d0d7de;\n        padding: 8px 12px;\n        text-align: left;\n        word-wrap: break-word;\n        overflow-wrap: break-word;\n      }\n      \n      #shadow-render-container th {\n        background: #f6f8fa;\n        font-weight: 600;\n      }\n      \n      /* 数学公式样式 - 固定字体大小 */\n      #shadow-render-container .katex {\n        font-size: 16px !important;\n      }\n      \n      #shadow-render-container .katex-display {\n        margin: 16px 0;\n        text-align: center;\n      }\n      \n      /* Mermaid图表样式 */\n      #shadow-render-container .mermaid {\n        text-align: center;\n        margin: 16px 0;\n      }\n      \n      /* 图片样式 */\n      #shadow-render-container img {\n        max-width: 100%;\n        height: auto;\n        display: block;\n        margin: 16px auto;\n      }\n      \n      /* 列表样式 */\n      #shadow-render-container ul, #shadow-render-container ol {\n        padding-left: 32px;\n        margin-bottom: 16px;\n      }\n      \n      #shadow-render-container li {\n        margin-bottom: 4px;\n      }\n      \n      /* 引用样式 */\n      #shadow-render-container blockquote {\n        border-left: 4px solid #d0d7de;\n        padding-left: 16px;\n        margin: 16px 0;\n        color: #656d76;\n        font-style: italic;\n      }\n    `}}window.StyleManager=StyleManager;