class PDFGenerator{constructor(e,t){this.rendererCore=e,this.messageHandler=t,this.svgConverter=new SvgConverter}async generatePDF(e,t){const{markdown:n,filename:r,options:a={}}=e;try{this.messageHandler.sendMessage("nextStep",{step:"converting_content",message:"正在转换特殊内容...",status:"converting_content"});const e=await this.convertSpecialContentToImages();return this.messageHandler.sendMessage("nextStep",{step:"generating_pdf",message:`内容转换完成（成功${e.success}个），正在生成PDF...`,status:"generating_pdf",stats:e}),await this.generatePDFDocument(a,r,t)}catch(e){console.error("[PDFGenerator] PDF生成失败:",e),this.messageHandler.sendMessage("pdfError",{error:e.message,requestId:t})}}async convertSpecialContentToImages(){const e={total:0,success:0,failed:0,errors:[]};try{const t=this.rendererCore.container.querySelectorAll('.mermaid-rendered svg, .mermaid svg, svg[id*="mermaid"]');if(t.length>0){const n=await this.convertElementsToImages(t,"Mermaid Diagram");this.mergeResults(e,n)}}catch(t){console.error("[PDFGenerator] 特殊内容转换失败:",t),e.errors.push(t.message)}return e}async convertElementsToImages(e,t){const n={total:e.length,success:0,failed:0,errors:[]};if(t.includes("LaTeX"))return n;for(let r=0;r<e.length;r++){const a=e[r];try{if(t.includes("Mermaid")){const e="svg"===a.tagName.toLowerCase()?a:a.querySelector("svg");if(!e)throw new Error("未找到 SVG 元素");const{width:r,height:o}=this.svgConverter.getSvgDimensions(e,{}),i=this.calculateOptimalPdfImageSize(r,o),s=await this.svgConverter.convertSvgToImage(e,{format:"png",backgroundColor:"#ffffff",scaleFactor:2,width:i.width,height:i.height}),l=document.createElement("img");l.src=s,l.alt=t,l.style.cssText=`\n            width: ${i.width}px;\n            height: ${i.height}px;\n            max-width: 100%;\n            display: block;\n            margin: 15px auto;\n            vertical-align: middle;\n          `,a.replaceWith(l),n.success++}}catch(e){console.error(`[PDFGenerator] ${t}转换失败:`,e),n.failed++,n.errors.push(`${t} ${r}: ${e.message}`)}}return n}mergeResults(e,t){e.total+=t.total,e.success+=t.success,e.failed+=t.failed,e.errors=e.errors.concat(t.errors)}async ensureKatexFontsLoaded(){if(document.fonts&&document.fonts.ready)try{return void await document.fonts.ready}catch(e){console.warn("[PDFGenerator] document.fonts.ready失败:",e)}await new Promise(e=>setTimeout(e,50))}ensureKatexStylesInTempDOM(e){e.querySelectorAll(".katex").forEach(e=>{const t=window.getComputedStyle(e).fontFamily;if(t.includes("KaTeX")){e.style.fontFamily=t,e.style.fontFeatureSettings="normal",e.style.fontVariant="normal",e.style.textRendering="optimizeLegibility";e.querySelectorAll(".katex-mathml, .mspace, .mord, .mop, .mrel, .mbin, .mpunct, .mopen, .mclose, .minner").forEach(e=>{e.style.fontFamily=t})}e.querySelectorAll(".sqrt, .root, .nulldelimiter").forEach(e=>{e.style.fontFamily="KaTeX_Main, Times New Roman, serif",e.style.fontFeatureSettings="normal"}),this.ensureSVGElementsRendered(e)})}ensureSVGElementsRendered(e){e.querySelectorAll("svg").forEach(t=>{t.style.display="block",t.style.position="absolute",t.style.width="100%",t.style.height="1.2em",t.style.fill="currentColor",t.style.stroke="currentColor",t.style.overflow="hidden";t.querySelectorAll("path").forEach(e=>{e.style.stroke="none",e.style.fill="currentColor"});e.querySelectorAll(".stretchy").forEach(e=>{e.style.width="100%",e.style.display="block",e.style.position="relative",e.style.overflow="hidden",e.style.maxHeight="1.2em"});const n=t.closest(".sqrt");n&&(n.style.display="inline-block",n.style.verticalAlign="baseline",t.parentElement===n&&(t.style.height="1em",t.style.maxHeight="1em"))})}applyKatexStylesGently(e){if(!e.classList.contains("katex"))return;const t=e.querySelector(".katex-html");t&&t.style.setProperty("display","inline","important");const n=e.querySelector(".katex-mathml");n&&(n.style.setProperty("position","absolute","important"),n.style.setProperty("clip","rect(1px, 1px, 1px, 1px)","important"),n.style.setProperty("padding","0","important"),n.style.setProperty("border","0","important"),n.style.setProperty("height","1px","important"),n.style.setProperty("width","1px","important"),n.style.setProperty("overflow","hidden","important")),e.style.setProperty("display","inline-block","important"),e.style.setProperty("visibility","visible","important");e.querySelectorAll("svg").forEach(e=>{e.style.setProperty("display","block","important"),e.style.setProperty("position","absolute","important"),e.style.setProperty("width","100%","important"),e.style.removeProperty("height"),e.style.setProperty("fill","currentColor","important"),e.style.setProperty("stroke","currentColor","important");e.closest(".sqrt")&&e.style.setProperty("overflow","hidden","important")});e.querySelectorAll(".sqrt").forEach(e=>{e.style.setProperty("position","relative","important"),e.style.removeProperty("max-height"),e.style.removeProperty("height");e.querySelectorAll("> *").forEach(e=>{"svg"===e.tagName||e.style.setProperty("vertical-align","baseline","important")})});if(e.querySelectorAll(".stretchy").forEach(e=>{e.style.setProperty("display","block","important"),e.style.setProperty("position","relative","important"),e.style.setProperty("width","100%","important"),e.style.removeProperty("max-height"),e.style.removeProperty("height");const t=e.parentElement;t&&t.classList.contains("sqrt")&&t.style.setProperty("overflow","hidden","important")}),!e.style.fontFamily||!e.style.fontFamily.includes("KaTeX")){const t=window.getComputedStyle(e);t.fontFamily.includes("KaTeX")&&e.style.setProperty("font-family",t.fontFamily,"important")}}forceApplyKatexStyles(e){this.applyKatexStylesGently(e)}copyComputedStyles(e,t){if(!e.classList.contains("katex")||!t.classList.contains("katex"))return;const n=window.getComputedStyle(e);["font-size","font-family","font-weight","font-style","line-height","text-rendering","color","display","position","vertical-align"].forEach(e=>{const r=n.getPropertyValue(e);r&&t.style.setProperty(e,r,"important")});const r=e.querySelectorAll("*"),a=t.querySelectorAll("*");r.forEach((e,t)=>{const n=a[t];if(n){const t=window.getComputedStyle(e);if((e.classList.contains("sqrt")||e.classList.contains("root")||"svg"===e.tagName)&&"svg"===e.tagName){const e=t.getPropertyValue("height");e&&"auto"!==e&&"0px"!==e&&(n.style.height=e)}n.style.fontFamily=t.fontFamily,n.style.fontSize=t.fontSize,n.style.fontWeight=t.fontWeight,n.style.fontStyle=t.fontStyle}})}async waitForFontsRender(){await new Promise(e=>{document.fonts&&document.fonts.ready?document.fonts.ready.then(e):setTimeout(e,300)}),await new Promise(e=>{requestAnimationFrame(e)})}async generatePDFDocument(e,t,n){try{const r=e.scale||2,a=document.body.style.cssText,o=this.rendererCore.container.style.cssText,i=this.rendererCore.config.container.width;let s=Math.max(this.rendererCore.container.scrollHeight,this.rendererCore.config.container.height);s<=0&&(console.warn("[PDFGenerator] 容器高度无效，使用默认高度",{scrollHeight:this.rendererCore.container.scrollHeight,configHeight:this.rendererCore.config.container.height,calculatedHeight:s}),s=this.rendererCore.config.container.height||1200);const l=document.createElement("style");l.id="pdf-generation-temp-style",l.textContent=`\n        body {\n          margin: 0 !important;\n          padding: 0 !important;\n          display: block !important;\n          justify-content: unset !important;\n          align-items: unset !important;\n          flex-direction: unset !important;\n        }\n        #render-container, .render-container {\n          position: absolute !important;\n          left: 0 !important;\n          top: 0 !important;\n          margin: 0 !important;\n          margin-left: 0 !important;\n          margin-right: 0 !important;\n          padding: 0 !important;\n          width: ${i}px !important;\n          max-width: ${i}px !important;\n        }\n      `,document.head.appendChild(l),document.body.style.cssText="\n        margin: 0 !important;\n        padding: 0 !important;\n        display: block !important;\n        justify-content: unset !important;\n        align-items: unset !important;\n        flex-direction: unset !important;\n      ",this.rendererCore.container.style.cssText=`\n        position: absolute !important;\n        left: 0 !important;\n        top: 0 !important;\n        margin: 0 !important;\n        margin-left: 0 !important;\n        margin-right: 0 !important;\n        padding: 0 !important;\n        padding-left: 0 !important;\n        padding-right: 0 !important;\n        width: ${i}px !important;\n        max-width: ${i}px !important;\n        min-width: ${i}px !important;\n        box-sizing: border-box !important;\n      `,await new Promise(e=>setTimeout(e,200));const c=await htmlToImage.toCanvas(this.rendererCore.container,{pixelRatio:r,backgroundColor:e.backgroundColor||"#ffffff",width:718,height:s,cacheBust:!0,useCORS:!0,allowTaint:!0,scrollX:0,scrollY:0,ignoreElements:e=>"STYLE"===e.tagName||"debug-panel"===e.id,filter:e=>"debug-panel"!==e.id&&(!e.classList||!e.classList.contains("debug-panel"))});if(!c||0===c.width||0===c.height)throw new Error(`Canvas生成失败或尺寸无效: ${c?.width||0}x${c?.height||0}px`);if(window.MD2PDF_Debug&&window.MD2PDF_Debug.enabled&&this.showCanvasDebug(c),!window.jspdf||!window.jspdf.jsPDF)throw new Error("jsPDF库不可用");const d=new window.jspdf.jsPDF({orientation:e.orientation||"portrait",unit:"mm",format:e.pageSize||"a4"}),h=d.internal.pageSize.getWidth(),m=d.internal.pageSize.getHeight(),g=c.toDataURL("image/png"),p=await this.addCanvasToPDF(d,c,g,r,i,h,m);this.messageHandler.sendMessage("nextStep",{step:"finalize",message:"正在保存PDF...",status:"finalize"}),window.MD2PDF_Progress&&window.MD2PDF_Progress.nextStep("finalize"),d.save(t||"document.pdf"),this.messageHandler.sendMessage("pdfComplete",{success:!0,filename:t,requestId:n,stats:p.stats});const u=document.getElementById("pdf-generation-temp-style");return u&&u.remove(),document.body.style.cssText=a,this.rendererCore.container.style.cssText=o,{success:!0}}catch(e){throw console.error("[PDFGenerator] 失败:",e),this.messageHandler.sendMessage("pdfError",{error:e.message,requestId:n}),new Error(`PDF生成失败: ${e.message}`)}}async addCanvasToPDF(e,t,n,r,a,o,i){const s=t.width/r,l=t.height/r,c=o-20,d=c/s,h=l*d;let m=i,g=o;h>i-20&&(m=h+20,m=Math.min(m,1e4));const p=new window.jspdf.jsPDF({orientation:"portrait",unit:"mm",format:[g,m]});return p.addImage(n,"PNG",10,10,c,h),Object.assign(e,p),{stats:{canvasSize:`${t.width}x${t.height}px`,canvasLogicalSize:`${s.toFixed(0)}x${l.toFixed(0)}px`,contentSize:`${c.toFixed(1)}x${h.toFixed(1)}mm`,pdfSize:`${g.toFixed(1)}x${m.toFixed(1)}mm`,scale:r,pxToMmRatio:d.toFixed(4),totalPages:1,mode:"single-page"}}}async getSmartPageBreaks(e,t,n){try{const r=n(),a=r*96/25.4,o=this.detectActualContentHeight(e);if(console.log("[PDFGenerator] 分页参数详情:",{canvasSize:`${e.width}x${e.height}`,canvasLogicalHeight:t,actualCanvasHeight:o,pageHeightMM:r.toFixed(1),pageHeightPX:a.toFixed(1),roundedPageHeightPX:Math.round(a),scale:2}),window.SmartPagination){console.log("[PDFGenerator] SmartPagination可用，调用SmartPagination，传入页面高度:",Math.round(a));const t=window.SmartPagination.process(e,{pageHeight:Math.round(a)});if(console.log("[PDFGenerator] SmartPagination返回结果:",{success:t.success,totalPages:t.totalPages,pagesCount:t.pages?.length,actualContentHeight:t.actualContentHeight,isEmpty:t.isEmpty,pages:t.pages?.map(e=>({pageNum:e.pageNumber,startY:e.startY,endY:e.endY,height:e.height,isFallback:e.isFallback}))}),t.success&&t.pages.length>1)return t}else console.error("[PDFGenerator] SmartPagination不可用！检查是否正确加载"),console.log("[PDFGenerator] 全局对象检查:",{SmartPagination:typeof window.SmartPagination,hasSmartPagination:"SmartPagination"in window});return console.log("[PDFGenerator] SmartPagination失败或返回单页，使用DOM分页"),await this.getDOMBasedPageBreaks(e,t,n)}catch(e){return console.error("[PDFGenerator] 智能分页检测失败:",e),{success:!1,pages:[]}}}async getDOMBasedPageBreaks(e,t,n){const r=n()/(25.4/96);let a=0,o=1;const i=[],s=this.rendererCore.container,l=Array.from(s.querySelectorAll("*"));for(;a<t;){let e=Math.min(a+r,t),n=e;for(const t of l)try{const r=t.getBoundingClientRect(),o=s.getBoundingClientRect(),i=r.top-o.top;if(i>a&&i<e){if(this.canBreakBeforeElement(t)&&i>a+50){n=i;break}}const l=i+r.height;if(l>a&&l<e){this.canBreakAfterElement(t)&&l<e-20&&(n=l)}}catch(e){}n-a<100&&n<t&&(n=e),i.push({pageNumber:o++,startY:a,endY:n,height:n-a}),a=n}return{success:!0,pages:i,totalPages:i.length}}canBreakBeforeElement(e){const t=e.tagName.toLowerCase(),n=e.className;return!n.includes("katex")&&!n.includes("mermaid")&&(!!["h1","h2","h3","h4","h5","h6","div","section","article","header","footer","ul","ol","blockquote","pre","hr","table"].includes(t)||!["p","li","td","th","span","strong","em","code","a"].includes(t))}canBreakAfterElement(e){const t=e.tagName.toLowerCase(),n=e.className;return!(!n.includes("katex")&&!n.includes("mermaid"))||(!!["h1","h2","h3","h4","h5","h6","p","div","section","article","header","footer","ul","ol","blockquote","pre","hr","table","li"].includes(t)||!["span","strong","em","code","a","br"].includes(t))}async addCanvasToPDFWithImprovedPagination(e,t,n,r,a,o,i,s,l,c){const d=i-2*s,h=this.detectActualContentHeight(t)/r*c;let m=Math.ceil(h/d);if(m>1){h-(m-1)*d<.2*d&&m--}const g=[];for(let e=0;e<m;e++){let n=e*d,a=Math.min(d,h-n);if(e<m-1){const e=await this.findBetterBreakPoint(t,n,a,c,r);e&&e>.8*a&&(a=e)}a>=10&&g.push({pageNumber:e+1,yOffset:n,remainingHeight:a,sourceY:n/c*r,sourceHeight:a/c*r})}for(let n=0;n<g.length;n++){const r=g[n];n>0&&e.addPage();const a=document.createElement("canvas");a.width=t.width,a.height=r.sourceHeight;a.getContext("2d").drawImage(t,0,r.sourceY,t.width,r.sourceHeight,0,0,t.width,r.sourceHeight);const o=a.toDataURL("image/png");e.addImage(o,"PNG",s,s,l,r.remainingHeight)}}async findBetterBreakPoint(e,t,n,r,a){const o=t/r*a,i=n/r*a,s=Math.min(.2*i,100);for(let t=o+i;t>=o+i-s;t-=10)if(this.isRowEmpty(e,t)){return(t-o)/a*r}return n}isRowEmpty(e,t,n=.95){try{const r=e.getContext("2d",{willReadFrequently:!0}),a=20,o=r.getImageData(0,t,e.width,1).data;let i=0,s=0;for(let e=0;e<o.length;e+=4*a){const t=o[e],n=o[e+1],r=o[e+2];s++,t>245&&n>245&&r>245&&i++}return(s>0?i/s:1)>n}catch(e){return!1}}showCanvasDebug(e){if(!e||0===e.width||0===e.height)return void console.warn("[PDFGenerator] Canvas调试跳过: Canvas尺寸无效",{width:e?.width||"undefined",height:e?.height||"undefined"});const t=document.createElement("canvas");t.width=Math.min(e.width/4,800),t.height=Math.min(e.height/4,600);const n=t.getContext("2d");n.drawImage(e,0,0,t.width,t.height),n.strokeStyle="red",n.lineWidth=2,n.beginPath(),n.moveTo(0,0),n.lineTo(0,t.height),n.stroke(),this.createInPageDebugPanel(t,e)}createInPageDebugPanel(e,t){const n=document.getElementById("canvas-debug-panel");n&&n.remove();const r=document.createElement("div");r.id="canvas-debug-panel",r.className="canvas-debug-panel",r.style.cssText="\n      position: fixed !important;\n      top: 20px !important;\n      right: 20px !important;\n      width: 420px !important;\n      max-height: 80vh !important;\n      background: white !important;\n      border: 2px solid #007cba !important;\n      border-radius: 8px !important;\n      box-shadow: 0 4px 20px rgba(0,0,0,0.3) !important;\n      z-index: 999999 !important;\n      padding: 15px !important;\n      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif !important;\n      font-size: 14px !important;\n      line-height: 1.4 !important;\n      color: #333 !important;\n      overflow: auto !important;\n      resize: both !important;\n    ";const a=document.createElement("div");a.style.cssText="\n      background: #007cba !important;\n      color: white !important;\n      margin: -15px -15px 15px -15px !important;\n      padding: 10px 15px !important;\n      border-radius: 6px 6px 0 0 !important;\n      font-weight: bold !important;\n      display: flex !important;\n      justify-content: space-between !important;\n      align-items: center !important;\n    ",a.innerHTML='\n      <span>[DEBUG] Canvas预览 (1/4缩放)</span>\n      <span id="close-debug-panel" style="cursor: pointer; font-size: 18px; line-height: 1;">&times;</span>\n    ';const o=document.createElement("div");o.innerHTML=`\n      <div style="margin-bottom: 12px; padding: 8px; background: #f8f9fa; border-radius: 4px; font-size: 12px;">\n        <strong>原始尺寸:</strong> ${t.width}×${t.height}px<br>\n        <strong>显示尺寸:</strong> ${e.width}×${e.height}px<br>\n        <strong>红线:</strong> 标记左边界，检查是否有空白边距\n      </div>\n      <div style="border: 2px solid #007cba; border-radius: 4px; overflow: hidden; text-align: center;">\n      </div>\n    `;o.querySelector("div:last-child").appendChild(e),r.appendChild(a),r.appendChild(o);r.querySelector("#close-debug-panel").addEventListener("click",()=>{r.remove()}),this.makeDebugPanelDraggable(r,a),document.body.appendChild(r)}makeDebugPanelDraggable(e,t){let n=!1,r=0,a=0,o=0,i=0;t.addEventListener("mousedown",e=>{"close-debug-panel"!==e.target.id&&(n=!0,o=e.clientX-r,i=e.clientY-a,t.style.cursor="grabbing")}),document.addEventListener("mousemove",t=>{n&&(t.preventDefault(),r=t.clientX-o,a=t.clientY-i,e.style.transform=`translate(${r}px, ${a}px)`)}),document.addEventListener("mouseup",()=>{n&&(n=!1,t.style.cursor="grab")}),t.style.cursor="grab"}async handleSmartPagination(){if(!window.SmartPagination)return{success:!1,message:"智能分页不可用"};try{return window.SmartPagination.process(this.rendererCore.container)}catch(e){return console.error("[PDFGenerator] 智能分页失败:",e),{success:!1,message:e.message}}}calculateOptimalPdfImageSize(e,t){const n=96/25.4,r=190*n,a=247*n;let o,i;if(e<=r&&t<=a)o=e,i=t;else{const n=r/e,s=a/t,l=Math.min(n,s);o=Math.round(e*l),i=Math.round(t*l)}return{width:Math.max(100,o),height:Math.max(100,i),widthMM:o/n,heightMM:i/n,scale:o/e}}detectActualContentHeight(e){try{const t=e.getContext("2d",{willReadFrequently:!0}),n=e.width,r=e.height,a=20;let o=r,i=240,s=0;const l=Math.min(300,r);for(let e=r-1;e>=Math.max(0,r-l);e-=3){const r=t.getImageData(0,e,n,1).data;let l=0,c=0;for(let e=0;e<r.length;e+=4*a){const t=r[e],n=r[e+1],a=r[e+2];c++,(t<i||n<i||a<i)&&l++}if(l/c>.02){if(s++,s>=2){o=e+3*s;break}}else s=0}let c=o+30;const d=.9*r;return c=Math.max(c,d),Math.min(c,r)}catch(t){return console.error("[PDFGenerator] 检测内容高度失败:",t),e.height}}validateAndFilterPages(e,t){if(!e||0===e.length)return[];const n=[];for(let r=0;r<e.length;r++){const a=e[r];if(a&&"number"==typeof a.height&&a.height>0&&a.height>=50&&"number"==typeof a.startY&&a.startY>=0&&a.startY<t&&"number"==typeof a.endY&&a.endY<=t&&a.startY<a.endY){const o={...a};if(r===e.length-1&&o.endY>t&&(o.endY=t,o.height=t-o.startY),o.height>=50&&o.height>0){const e=n[n.length-1];!e||Math.abs(o.startY-e.startY)>5||Math.abs(o.height-e.height)>5?n.push(o):console.warn("[PDFGenerator] 过滤重复页面:",o)}else console.warn("[PDFGenerator] 过滤高度不足的页面:",{height:o.height,minHeight:50,startY:o.startY,endY:o.endY})}else console.warn("[PDFGenerator] 过滤无效页面:",{height:a?.height,startY:a?.startY,endY:a?.endY,totalHeight:t,reason:a?a.height<=0?"高度为0或负数":a.height<50?"高度过小":a.startY>=a.endY?"起始位置大于结束位置":"其他原因":"页面不存在"})}return 0===n.length&&e.length>0&&console.warn("[PDFGenerator] 所有页面都被过滤，原始页面数:",e.length),n}async fallbackCanvasConversion(e,t,n,r="transparent"){const a=document.createElement("canvas"),o=a.getContext("2d");a.width=2*t,a.height=2*n,r&&"transparent"!==r&&(o.fillStyle=r,o.fillRect(0,0,a.width,a.height)),o.fillStyle="#000000",o.font='32px "Times New Roman", serif',o.textAlign="center",o.textBaseline="middle";let i="";const s=e.querySelector(".katex-mathml");if(s&&(i=s.textContent||s.innerText||""),!i){const t=e.querySelector(".katex-html");t&&(i=t.textContent||t.innerText||"")}return i||(i=e.textContent||e.innerText||"√x"),o.fillText(i,a.width/2,a.height/2),a.toDataURL("image/png",.9)}}window.PDFGenerator=PDFGenerator;