# Progress Manager 国际化修改说明

## 修改日期
2025-01-06

## 修改内容

### 1. 添加了国际化功能支持
- 在文件开头添加了对 i18n.js 的引用说明
- 添加了 `messages` 属性用于缓存国际化消息

### 2. 新增的辅助方法
- `getI18nText(key)`: 异步获取国际化文本
- `getTranslation(messages, key)`: 从已加载的消息中获取翻译
- `getFallbackText(key)`: 获取英文fallback文本

### 3. 修改的方法和对应的国际化键名

#### createUI() 方法
- 硬编码的 "处理中..." → 使用 "progressConverting"

#### show() 方法
- 默认参数 "处理中..." → 使用 "progressConverting"
- 方法改为 async 以支持异步获取文本

#### complete() 方法
- 默认参数 "完成" → 使用 "progressCompleted"
- 方法改为 async 以支持异步获取文本

#### error() 方法
- 默认参数 "失败" → 使用 "progressFailed"
- 方法改为 async 以支持异步获取文本

#### start() 方法
- "PDF转换中..." → 使用 "progressPdfConversion"
- "Word转换中..." → 使用 "progressWordConversion"
- 方法改为 async 以支持异步获取文本

#### nextStep() 方法
- "PDF生成成功" → 使用 "progressPdfCompleted"
- "Word文档生成成功" → 使用 "progressWordCompleted"
- 方法改为 async 以支持异步获取文本

### 4. 兼容性保证
- 如果 i18n.js 不可用，会自动使用英文fallback文本
- 保持了所有原有API的兼容性，只是将部分方法改为异步

### 5. 注意事项
- 此文件现在依赖于 i18n.js，需要确保 i18n.js 先加载
- 调用这些方法时需要使用 await 关键字（如果需要等待结果）
- 国际化消息会被缓存，避免重复加载

## 使用的国际化键名
- progressConverting
- progressCompleted
- progressFailed
- progressPdfConversion
- progressWordConversion
- progressPdfCompleted
- progressWordCompleted