#!/usr/bin/env node

/**
 * 测试环境验证脚本
 * 验证工具类能否正确加载和基本功能
 */

console.log('🔍 开始验证测试环境...\n');

// 测试MathContentDetector加载
try {
  const MathContentDetector = require('../MathContentDetector.js');
  console.log('✅ MathContentDetector 加载成功');
  
  const detector = new MathContentDetector();
  console.log('✅ MathContentDetector 实例化成功');
  
  // 测试基本功能
  const testText = 'Test: $$E = mc^2$$ formula.';
  const blocks = detector.extractMathBlocks(testText);
  console.log(`✅ extractMathBlocks 工作正常，检测到 ${blocks.length} 个数学块`);
  
  const hasDisplay = detector.isDisplayMath(testText);
  console.log(`✅ isDisplayMath 返回: ${hasDisplay.isMath} (类型: ${hasDisplay.type})`);
  
} catch (error) {
  console.error('❌ MathContentDetector 验证失败:', error.message);
}

console.log('');

// 测试DollarDollarProtector加载  
try {
  const DollarDollarProtector = require('../DollarDollarProtector.js');
  console.log('✅ DollarDollarProtector 加载成功');
  
  const protector = new DollarDollarProtector();
  console.log('✅ DollarDollarProtector 实例化成功');
  
  // 测试基本功能
  const testText = 'Test: $$E = mc^2$$ formula.';
  const result = protector.protect(testText);
  console.log(`✅ protect 工作正常，保护了 ${protector.getProtectionCount()} 个公式`);
  
  const restored = protector.restore(result);
  console.log(`✅ restore 工作正常，恢复后文本长度: ${restored.length}`);
  
  const isEqual = restored === testText;
  console.log(`✅ 往返转换正确性: ${isEqual ? '通过' : '失败'}`);
  
} catch (error) {
  console.error('❌ DollarDollarProtector 验证失败:', error.message);
}

console.log('');

// 测试协同工作
try {
  const MathContentDetector = require('../MathContentDetector.js');
  const DollarDollarProtector = require('../DollarDollarProtector.js');
  
  const detector = new MathContentDetector();
  const protector = new DollarDollarProtector();
  
  const testText = `
\\begin{equation}
E = mc^2
\\end{equation}

Display: $$F = ma$$ and inline: $v = u + at$.
  `;
  
  // 保护-检测-恢复流程
  const protectedText = protector.protect(testText);
  const envResult = detector.isMathEnvironment(protectedText);
  const restored = protector.restore(protectedText);
  
  console.log('✅ 协同工作测试通过:');
  console.log(`   - 保护了 ${protector.getProtectionCount()} 个$$公式`);
  console.log(`   - 检测到数学环境: ${envResult.isMath ? envResult.environment || '是' : '否'}`);
  console.log(`   - 恢复后文本完整性: ${restored === testText ? '通过' : '失败'}`);
  
} catch (error) {
  console.error('❌ 协同工作验证失败:', error.message);
}

console.log('\n🎉 环境验证完成！');
console.log('\n📋 接下来可以运行:');
console.log('   node run-tests.js              # 运行所有测试');
console.log('   node run-tests.js --coverage   # 运行测试并生成覆盖率报告');
console.log('   node run-tests.js MathContentDetector  # 运行特定测试');