# Utils模块测试套件

本目录包含LaTeX Parser V3 Utils模块的完整测试套件，基于interface.md规范编写。

## 📁 测试文件结构

```
tests/
├── README.md                           # 本说明文件
├── run-tests.js                        # 测试运行器（可执行）
├── MathContentDetector.test.js         # MathContentDetector单元测试
├── DollarDollarProtector.test.js       # DollarDollarProtector单元测试
└── utils-integration.test.js           # 工具类集成测试
```

## 🧪 测试覆盖范围

### MathContentDetector测试 (39个测试用例)

**核心接口测试**:
- ✅ `isMathEnvironment(content)` - 数学环境识别和分类
- ✅ `isInlineMath(content)` - 行内数学检测
- ✅ `isDisplayMath(content)` - 显示数学检测
- ✅ `extractMathBlocks(content)` - 提取所有类型的数学块
- ✅ `classifyContent(content)` - 数学内容智能分类
- ✅ `hasMathContent(content)` - 数学内容存在性检测

**支持的数学环境**:
- 显示数学: `equation`, `equation*`, `align`, `align*`, `gather`, `gather*`, `multline`, `multline*`
- 矩阵环境: `matrix`, `pmatrix`, `bmatrix`, `vmatrix`, `Vmatrix`
- 数组环境: `array`, `eqnarray`, `eqnarray*`
- 特殊环境: `displaymath`, `split`

**边界条件和错误处理**:
- 空输入处理
- 无效输入处理
- 格式错误的环境
- 嵌套环境处理
- 特殊字符处理
- 性能测试（大文档处理）

### DollarDollarProtector测试 (48个测试用例)

**核心接口测试**:
- ✅ `protect(text)` - 保护$$数学公式
- ✅ `restore(text)` - 恢复受保护的公式
- ✅ `hasDoubleDollarMath(text)` - 检测$$数学公式
- ✅ `getProtectionCount()` - 获取保护数量
- ✅ `clear()` - 清理保护记录

**保护机制验证**:
- 占位符格式: `__DD_PROTECTED_{id}__`
- 自动计数器唯一性
- JavaScript $符特殊字符处理
- 文本长度一致性
- 多公式保护和恢复

**错误处理和性能**:
- 无效输入处理
- 不匹配的$$处理
- 内存管理和清理
- 大文档处理性能
- 连续公式处理

### 集成测试 (15个测试用例)

**协同工作验证**:
- 保护后的数学环境检测
- 混合内容处理
- 保护-检测-恢复完整流程
- LayerParser使用模式模拟

**接口稳定性**:
- 接口契约一致性
- 异常情况下的接口保障
- 性能优化集成测试

## 🚀 运行测试

### 基本使用

```bash
# 运行所有测试
node run-tests.js

# 运行测试并生成覆盖率报告
node run-tests.js --coverage

# 显示详细输出
node run-tests.js --verbose

# 监视模式（文件变化时自动重运行）
node run-tests.js --watch
```

### 指定测试

```bash
# 只运行MathContentDetector测试
node run-tests.js MathContentDetector

# 只运行DollarDollarProtector测试  
node run-tests.js DollarDollarProtector

# 只运行集成测试
node run-tests.js integration

# 组合选项
node run-tests.js MathContentDetector --coverage --verbose
```

### 查看帮助

```bash
node run-tests.js --help
```

## 📊 测试报告

### 覆盖率报告

运行带`--coverage`参数的测试后：

- **HTML报告**: `tests/coverage/lcov-report/index.html`
- **终端报告**: 直接显示在控制台
- **LCOV报告**: `tests/coverage/lcov.info`

### 预期测试结果

- **总测试用例数**: 102个 (39+48+15)
- **预期通过率**: 100%
- **目标覆盖率**: ≥90%

## ⚠️ 运行要求

### 前置条件

1. **Jest框架**: 
   ```bash
   npm install --save-dev jest
   ```

2. **必需文件存在**:
   - `../MathContentDetector.js`
   - `../DollarDollarProtector.js`
   - `../interface.md`

### 环境要求

- Node.js 12+
- Jest测试框架
- 支持ES6语法的环境

## 🔧 测试开发指南

### 添加新测试

1. 参照现有测试文件结构
2. 遵循interface.md规范
3. 包含正向和反向测试用例
4. 添加边界条件测试
5. 更新本README文档

### 测试用例命名规范

```javascript
// ✅ 好的测试命名
test('应该检测equation环境', () => { /* ... */ });
test('应该处理空输入而不抛出异常', () => { /* ... */ });
test('应该在保护后仍能检测数学环境', () => { /* ... */ });

// ❌ 避免的命名
test('test1', () => { /* ... */ });
test('detector works', () => { /* ... */ });
```

### 断言模式

```javascript
// 接口契约验证
expect(result).toMatchObject({
  type: expect.any(String),
  content: expect.any(String),
  startPos: expect.any(Number),
  endPos: expect.any(Number)
});

// 数组内容验证
expect(Array.isArray(environments)).toBe(true);
expect(environments).toHaveLength(expectedLength);

// 错误处理验证
expect(() => {
  detector.methodName(invalidInput);
}).not.toThrow();
```

## 📈 持续改进

### 当前状态

- ✅ 完整接口覆盖
- ✅ 边界条件测试
- ✅ 错误处理测试
- ✅ 集成测试
- ✅ 性能测试

### 改进方向

- 🔄 增加更多真实场景测试
- 🔄 性能基准测试优化
- 🔄 模糊测试(Fuzz Testing)
- 🔄 并发测试场景

## 🐛 问题报告

发现测试问题时请提供：

1. **运行环境**: Node.js版本、Jest版本
2. **错误信息**: 完整的错误输出
3. **重现步骤**: 具体的命令和输入
4. **预期行为**: 期望的测试结果
5. **实际行为**: 实际的测试结果

## 🤝 贡献指南

1. 所有新功能必须有对应测试
2. 测试覆盖率不得低于90%
3. 所有测试必须通过
4. 遵循现有代码风格
5. 更新相关文档

---

**基于interface.md规范编写** | **TDD驱动开发** | **100%接口覆盖**