# Renderers 模块接口文档

## 模块概述

Renderers 模块负责将LaTeX解析结果转换为最终输出格式。该模块提供HTML渲染器和CSS生成器，将结构化的解析数据转换为可用的HTML内容和对应的样式表。

## 公共接口

### HTMLRenderer

**位置**: `renderers/HTMLRenderer.js`

**职责**: 将解析结果转换为格式正确的HTML内容

**构造函数**:
```javascript
new HTMLRenderer(config = {})
```

**配置选项**:
- `htmlMapping` {Object} - HTML映射配置，默认使用 `config/latex-html-mapping.js`
- `includeContainer` {Boolean} - 是否包含容器元素，默认true
- `escapeContent` {Boolean} - 是否转义内容，默认true  
- `addComments` {Boolean} - 是否添加HTML注释，默认false

**核心方法**:
```javascript
render(parseResult: ParseResult): String
renderBlocks(blocks: Array): String  
renderMetadata(metadata: Object): String
renderMathContent(mathBlocks: Array): String
renderStructure(structure: Object): String
```

**输入格式 (ParseResult)**:
```javascript
{
  success: Boolean,
  processedText: String,
  blocks: Array,           // 结构化数据块
  metadata: Object,        // 文档元信息
  warnings: Array,
  errors: Array
}
```

**输出格式**: 完整的HTML字符串，包含：
- 文档结构标记
- 语义化HTML元素
- KaTeX兼容的数学公式标记
- 可访问性属性

### CSSGenerator  

**位置**: `renderers/CSSGenerator.js`

**职责**: 生成与HTML输出匹配的CSS样式表

**构造函数**:
```javascript
new CSSGenerator(config = {})
```

**配置选项**:
- `cssRules` {Object} - CSS规则配置，默认使用 `config/latex-css-rules.js`
- `theme` {String} - 主题名称，默认 'default'
- `responsive` {Boolean} - 是否包含响应式样式，默认true
- `print` {Boolean} - 是否包含打印样式，默认true

**核心方法**:
```javascript
generate(parseResult: ParseResult): String
generateBlockStyles(blocks: Array): String
generateTheme(theme: String): String
generateResponsiveStyles(): String
generatePrintStyles(): String
```

**输出格式**: 完整的CSS字符串，包含：
- 基础样式重置
- LaTeX元素样式
- 数学公式样式
- 响应式媒体查询
- 打印优化样式

## 详细接口规范

### HTMLRenderer 方法详情

#### render(parseResult)

主渲染方法，将完整的解析结果转换为HTML。

**参数**:
- `parseResult` {ParseResult} - 来自LaTeXParser的解析结果

**返回值**: {String} - 完整的HTML文档片段

**示例**:
```javascript
const renderer = new HTMLRenderer();
const html = renderer.render(parseResult);
// 输出: <div class="latex-document">...</div>
```

#### renderBlocks(blocks)

渲染特定的数据块集合。

**参数**:
- `blocks` {Array} - 数据块数组

**返回值**: {String} - 渲染后的HTML片段

#### renderMetadata(metadata)

渲染文档元信息（标题、作者、日期等）。

**参数**:
- `metadata` {Object} - 元数据对象

**返回值**: {String} - 元数据的HTML表示

### CSSGenerator 方法详情

#### generate(parseResult)

主生成方法，为解析结果创建匹配的CSS。

**参数**:
- `parseResult` {ParseResult} - 解析结果

**返回值**: {String} - 完整的CSS样式表

#### generateBlockStyles(blocks)

为特定数据块生成CSS规则。

**参数**:
- `blocks` {Array} - 需要样式的数据块

**返回值**: {String} - 相应的CSS规则

## 数据块处理

### 支持的数据块类型

- **文档结构块**: section, subsection, title, author
- **列表块**: itemize, enumerate, description  
- **表格块**: tabular, array
- **数学块**: equation, align, gather
- **图片块**: figure, includegraphics
- **引用块**: cite, ref, footnote

### 数据块格式

```javascript
{
  type: String,            // 数据块类型
  content: String,         // 原始内容
  attributes: Object,      // HTML属性
  metadata: Object,        // 块级元信息
  children: Array         // 嵌套子块（可选）
}
```

## HTML输出规范

### 语义化标记

- 使用语义化HTML5元素
- 提供适当的ARIA属性
- 遵循Web可访问性标准

### CSS类命名规范

- 前缀: `latex-` 
- BEM方法论: `latex-block__element--modifier`
- 示例: `latex-section`, `latex-math__display`, `latex-list--ordered`

### KaTeX集成

数学内容使用KaTeX兼容标记：
```html
<span class="katex-display">$$E = mc^2$$</span>
<span class="katex-inline">$x = y$</span>
```

## 依赖关系

### 输入依赖
- `core/LaTeXParser.js` - 接收解析结果
- `config/latex-html-mapping.js` - 使用HTML映射
- `config/latex-css-rules.js` - 使用CSS规则

### 输出依赖  
- 浏览器环境 - HTML/CSS输出供浏览器渲染
- PDF生成器 - 提供结构化内容用于PDF转换
- Word导出器 - 提供格式化内容

### 可选依赖
- KaTeX - 数学公式渲染支持
- 主题系统 - 自定义样式主题

## 错误处理约定

### HTML渲染错误
- 无效数据块时输出警告注释
- 缺失配置时使用默认HTML标签
- 保持输出的有效性，避免破坏文档结构

### CSS生成错误  
- 无效样式规则时跳过并警告
- 缺失主题时回退到默认样式
- 确保生成的CSS语法正确

## 扩展性设计

### 自定义渲染器
- 支持继承HTMLRenderer创建自定义渲染器
- 提供渲染钩子函数扩展功能
- 支持自定义数据块处理器

### 主题系统
- 支持多主题CSS生成
- 允许自定义CSS规则集
- 提供主题切换接口

### 输出格式扩展
- 设计允许添加新的输出格式（如Markdown、XML）
- 提供统一的渲染接口标准
- 支持自定义输出适配器