/**
 * Jest 配置文件 - LaTeX Parser V3 测试
 */

module.exports = {
  // 测试环境
  testEnvironment: 'node',

  // 测试文件匹配模式
  testMatch: [
    '<rootDir>/tests/**/*.spec.js',
    '<rootDir>/tests/**/*.test.js'
  ],

  // 测试超时时间（毫秒）
  testTimeout: 30000,

  // 覆盖率配置
  collectCoverage: true,
  coverageDirectory: 'coverage',
  coverageReporters: ['text', 'lcov', 'html'],
  collectCoverageFrom: [
    'core/**/*.js',
    'browser.js',
    'renderers/**/*.js',
    'processors/**/*.js',
    '!core/tests/**',
    '!tests/**',
    '!coverage/**',
    '!node_modules/**'
  ],

  // 覆盖率阈值
  coverageThreshold: {
    global: {
      branches: 70,
      functions: 70,
      lines: 70,
      statements: 70
    }
  },

  // 测试设置文件
  setupFilesAfterEnv: ['<rootDir>/tests/jest.setup.js'],

  // 模块路径映射
  moduleNameMapping: {},

  // 忽略的测试路径
  testPathIgnorePatterns: [
    '/node_modules/',
    '/coverage/',
    'test-runner.js',
    'simple-test.js'
  ],

  // 详细输出
  verbose: true,

  // 错误时不退出
  bail: false,

  // 缓存目录
  cacheDirectory: '<rootDir>/.jest-cache',

  // 清除模拟
  clearMocks: true,

  // 测试结果处理器
  reporters: [
    'default',
    ['jest-html-reporter', {
      pageTitle: 'LaTeX Parser V3 测试报告',
      outputPath: 'tests/test-report.html',
      includeFailureMsg: true,
      includeSuiteFailure: true
    }]
  ],

  // 全局变量
  globals: {
    NODE_ENV: 'test'
  },

  // 转换配置（如果需要）
  transform: {},

  // 模块文件扩展名
  moduleFileExtensions: ['js', 'json'],

  // 运行测试前的脚本
  globalSetup: undefined,
  globalTeardown: undefined,

  // 测试匹配的最大并发数
  maxConcurrency: 5,

  // 错误映射
  errorOnDeprecated: true,

  // 监视模式配置
  watchPathIgnorePatterns: [
    '/node_modules/',
    '/coverage/',
    '/.jest-cache/'
  ]
};