# 快速使用指南

## 运行测试

### 基本用法

```bash
# 在 core 目录下运行
cd /mnt/d/sycdata/gcf/md2pdf/lib/latex-parser-v3/core

# 运行所有测试
node tests/run-tests.js

# 或使用 Jest 直接运行
npx jest tests/
```

### 常用命令

```bash
# 验证测试环境
node tests/run-tests.js --validate

# 查看测试统计信息
node tests/run-tests.js --stats

# 运行带覆盖率的测试
node tests/run-tests.js --coverage

# 运行特定模块测试
node tests/run-tests.js LaTeXParser
node tests/run-tests.js MathParser

# 运行特定层级测试
node tests/run-tests.js --layer 1  # L1层测试
node tests/run-tests.js --layer 4  # L4层测试

# 监视模式运行
node tests/run-tests.js --watch
```

### 预期结果

- ✅ 所有6个测试文件应该可以正常运行
- ✅ 测试环境验证应该通过
- ✅ 每个解析器的接口规范应该得到完整验证
- ✅ 占位符机制应该在所有层级正常工作
- ✅ 错误处理应该符合容错和严格模式要求

## 测试覆盖内容

1. **LaTeXParser** - 主控制器集成测试
2. **DocumentParser** - L1层文档结构处理
3. **BlockElementParser** - L2层块级元素处理
4. **InlineElementParser** - L3层行内元素处理  
5. **MathParser** - L4层数学公式处理
6. **SpecialParser** - L5层特殊功能处理

每个测试文件都严格基于 `interface.md` 规范进行验证。