# Config 模块测试套件

本目录包含了 LaTeX Parser V3 Config 模块的完整测试套件，基于 `interface.md` 文档规范编写。

## 测试结构

### 测试文件

- **`latex-html-mapping.test.js`** - LATEX_HTML_MAPPING 接口测试
  - 接口存在性测试
  - 文档结构配置测试  
  - 接口规范一致性测试
  - 特殊配置类型测试
  - 映射完整性测试
  - 扩展性测试
  - 错误处理测试

- **`latex-css-rules.test.js`** - LATEX_CSS_RULES 和 CSS_UTILS 接口测试
  - CSS规则配置测试
  - CSS工具函数测试
  - 样式规范验证
  - CSS生成功能测试
  - 边界条件测试

- **`config-integration.test.js`** - 模块集成测试
  - 模块完整性测试
  - 配置一致性测试
  - 依赖关系验证
  - 错误处理约定验证
  - 扩展性设计验证
  - 性能测试

### 配置文件

- **`README.md`** - 本文档

## 运行测试

### 运行所有测试

```bash
npm test
```

### 运行特定测试

```bash
# HTML映射测试
npm run test:html-mapping

# CSS规则测试  
npm run test:css-rules

# 集成测试
npm run test:integration
```

### 监视模式

```bash
npm run test:watch
```

### 生成覆盖率报告

```bash
npm run test:coverage
```

## 测试覆盖范围

### LATEX_HTML_MAPPING 测试覆盖

✅ **接口存在性** - 验证对象和属性存在  
✅ **文档结构配置** - 验证 title, author, date, section 等配置  
✅ **接口规范一致性** - 验证所有配置项符合规范结构  
✅ **特殊配置类型** - 验证 ignore, isContainer, isClosing, selfClosing 类型  
✅ **映射完整性** - 验证包含所有必需的配置项  
✅ **扩展性** - 验证支持动态添加新配置  
✅ **错误处理** - 验证边界条件和异常处理

### LATEX_CSS_RULES 测试覆盖

✅ **CSS规则配置** - 验证文档结构、标题、章节样式  
✅ **CSS工具函数** - 验证 objectToCss 和 generateFullCSS 方法  
✅ **样式规范验证** - 验证CSS属性和值的有效性  
✅ **CSS生成功能** - 验证完整CSS样式表的生成  
✅ **边界条件处理** - 验证异常输入的处理

### CSS_UTILS 测试覆盖

✅ **objectToCss 方法** - CSS对象转换功能  
✅ **generateFullCSS 方法** - 完整CSS生成功能  
✅ **驼峰命名转换** - CSS属性名转换  
✅ **边界条件处理** - 空对象、特殊字符、null/undefined

### 集成测试覆盖

✅ **模块完整性** - 验证所有模块正确加载  
✅ **配置一致性** - 验证HTML映射和CSS规则的一致性  
✅ **依赖关系验证** - 验证无外部依赖和正确导出  
✅ **错误处理约定** - 验证异常处理机制  
✅ **扩展性设计** - 验证动态配置和主题支持  
✅ **性能测试** - 验证配置访问和CSS生成性能

## 测试质量指标

### 覆盖率目标

- **分支覆盖率**: ≥ 80%
- **函数覆盖率**: ≥ 80%  
- **行覆盖率**: ≥ 80%
- **语句覆盖率**: ≥ 80%

### 测试数量统计

- **HTML映射测试**: ~40个测试用例
- **CSS规则测试**: ~35个测试用例
- **集成测试**: ~25个测试用例
- **总计**: ~100个测试用例

## 接口规范验证

本测试套件严格按照 `../interface.md` 中定义的接口规范编写：

### LATEX_HTML_MAPPING 规范验证

```javascript
// 验证接口结构
LATEX_HTML_MAPPING = {
  [latexCommand]: {
    tag: String,           // ✅ 已测试
    className: String,     // ✅ 已测试
    attributes: Object,    // ✅ 已测试
    wrapper: Object,       // ✅ 已测试
    transform: Function    // ✅ 已测试
  }
}
```

### LATEX_CSS_RULES 规范验证

```javascript
// 验证接口结构  
LATEX_CSS_RULES = {
  [className]: {
    styles: Object,        // ✅ 已测试
    responsive: Object,    // ✅ 已测试
    print: Object         // ✅ 已测试
  }
}
```

### CSS_UTILS 规范验证

✅ **objectToCss** - CSS对象转换功能  
✅ **generateFullCSS** - 完整CSS生成功能

## 错误处理验证

✅ **配置加载失败** - 提供默认配置机制  
✅ **无效配置项** - 自动忽略并输出警告  
✅ **核心配置可用** - 确保关键配置项始终存在

## 扩展性验证

✅ **动态添加LaTeX命令映射** - 支持运行时扩展  
✅ **自定义CSS主题配置** - 支持主题定制  
✅ **环境特定配置覆盖** - 支持开发/生产环境配置

## 维护说明

### 添加新测试

1. 在对应的测试文件中添加新的测试用例
2. 确保测试用例符合interface.md规范
3. 运行测试确保通过
4. 更新本README文档

### 修改接口规范

1. 首先更新 `../interface.md` 文档
2. 修改相应的测试用例以反映新规范
3. 更新实现代码
4. 运行完整测试套件

### 性能优化

- 监控测试运行时间，确保每个测试用例 < 100ms
- 优化大数据量测试的效率
- 使用适当的测试隔离避免副作用