/**
 * LaTeX 到 HTML 映射配置
 * 定义LaTeX命令如何转换为HTML元素
 */

const LATEX_HTML_MAPPING = {
  // 文档结构
  title: { 
    tag: 'h1', 
    className: 'document-title',
    attributes: { role: 'banner' }
  },
  
  author: { 
    tag: 'div', 
    className: 'document-author',
    attributes: { role: 'contentinfo' }
  },
  
  date: { 
    tag: 'div', 
    className: 'document-date',
    attributes: { role: 'contentinfo' }
  },
  
  maketitle: {
    tag: 'div',
    className: 'title-separator',
    selfClosing: true
  },

  // 章节结构
  section: { 
    tag: 'h2', 
    className: 'latex-section',
    attributes: { role: 'heading', 'aria-level': '2' }
  },
  
  subsection: { 
    tag: 'h3', 
    className: 'latex-subsection',
    attributes: { role: 'heading', 'aria-level': '3' }
  },
  
  subsubsection: { 
    tag: 'h4', 
    className: 'latex-subsubsection',
    attributes: { role: 'heading', 'aria-level': '4' }
  },

  // 段落和内容
  paragraph: {
    tag: 'p',
    className: 'latex-content'
  },

  // 文档环境
  document_begin: {
    tag: 'div',
    className: 'latex-document',
    isContainer: true
  },

  document_end: {
    tag: '/div',
    isClosing: true
  },

  // 特殊命令 - 不渲染为HTML
  documentclass: { ignore: true },
  usepackage: { ignore: true },
  geometry: { ignore: true },
  pagestyle: { ignore: true },
  pagenumbering: { ignore: true },
  setlength: { ignore: true },
  renewcommand: { ignore: true },
  newcommand: { ignore: true },
  today: { ignore: true }
};

// 导出
if (typeof module !== 'undefined' && module.exports) {
  module.exports = { LATEX_HTML_MAPPING };
} else if (typeof window !== 'undefined') {
  window.LATEX_HTML_MAPPING = LATEX_HTML_MAPPING;
}