# Config 模块接口文档

## 模块概述

Config 模块负责LaTeX Parser V3的配置管理，包括LaTeX命令到HTML的映射规则、CSS样式规则定义以及渲染配置。该模块为整个解析系统提供统一的配置接口，确保各层解析器使用一致的转换规则。

## 公共接口

### LATEX_HTML_MAPPING

LaTeX命令到HTML元素的映射配置对象。

**位置**: `config/latex-html-mapping.js`

**接口规范**:
```javascript
LATEX_HTML_MAPPING = {
  [latexCommand]: {
    tag: String,           // HTML标签名
    className: String,     // CSS类名
    attributes: Object,    // HTML属性对象
    wrapper: Object,       // 包装元素配置（可选）
    transform: Function    // 自定义转换函数（可选）
  }
}
```

**主要配置项**:
- **文档结构**: `title`, `author`, `date`, `section`, `subsection`, `subsubsection`
- **文本格式**: `textbf`, `textit`, `emph`, `underline`, `texttt`
- **列表环境**: `itemize`, `enumerate`, `description`
- **数学环境**: `equation`, `align`, `gather`
- **特殊元素**: `footnote`, `cite`, `ref`

**使用示例**:
```javascript
const mapping = LATEX_HTML_MAPPING.textbf;
// { tag: 'strong', className: 'latex-textbf' }
```

### LATEX_CSS_RULES

LaTeX样式到CSS规则的映射配置。

**位置**: `config/latex-css-rules.js`

**接口规范**:
```javascript
LATEX_CSS_RULES = {
  [className]: {
    styles: Object,        // CSS样式对象
    responsive: Object,    // 响应式样式（可选）
    print: Object         // 打印样式（可选）
  }
}
```

**主要规则类别**:
- **文档结构样式**: 章节标题、段落间距
- **文本格式样式**: 粗体、斜体、下划线
- **列表样式**: 有序/无序列表缩进
- **数学样式**: 公式显示和对齐
- **表格样式**: 边框、对齐、间距

## 依赖关系

### 输出依赖
- `core/LaTeXParser.js` - 使用配置初始化解析器
- `renderers/HTMLRenderer.js` - 使用HTML映射配置
- `renderers/CSSGenerator.js` - 使用CSS规则配置
- 所有core解析器 - 使用转换规则

### 输入依赖
- 无外部依赖
- 提供基础配置数据

## 错误处理约定

- 配置文件加载失败时提供默认配置
- 无效配置项自动忽略并输出警告
- 确保核心配置项始终可用

## 扩展性设计

- 支持动态添加新的LaTeX命令映射
- 支持自定义CSS主题配置
- 支持环境特定的配置覆盖（开发/生产）