class MD2PDFController{constructor(){this.initialized=!1,this.modules={},this.init()}async init(){try{await this.waitForModules(),await this.initializeI18n(),await this.syncDebugMode(),this.setupEventListeners(),this.setupChromeMessageListeners(),this.exposeGlobalAPI(),this.initialized=!0}catch(e){console.error("[MD2PDF] 初始化失败:",e)}}async syncDebugMode(){try{const e=await chrome.runtime.sendMessage({action:"getDebugMode"});e&&e.enabled&&window.StyleConfig&&window.StyleConfig.enableDebugMode()}catch(e){}}async waitForModules(){const e=["MD2PDF_Utils","MD2PDF_UI","MD2PDF_Styles","MD2PDF_PDFConverter","MD2PDF_MarkdownConverter"],t=Date.now();for(;!this.areModulesReady(e)&&Date.now()-t<5e3;)await new Promise(e=>setTimeout(e,100));if(!this.areModulesReady(e))throw new Error("模块加载超时");this.modules={utils:window.MD2PDF_Utils,ui:window.MD2PDF_UI,styles:window.MD2PDF_Styles,pdfConverter:window.MD2PDF_PDFConverter,markdownConverter:window.MD2PDF_MarkdownConverter}}areModulesReady(e){return e.every(e=>window[e])}async initializeI18n(){window.MD2PDF_I18N&&window.MD2PDF_I18N.initializeTexts&&await window.MD2PDF_I18N.initializeTexts()}setupEventListeners(){document.addEventListener("keydown",e=>this.handleKeyDown(e)),window.md2pdfOnElementSelected=e=>this.handleElementSelected(e)}setupChromeMessageListeners(){"undefined"!=typeof chrome&&chrome.runtime&&chrome.runtime.onMessage&&chrome.runtime.onMessage.addListener((e,t,o)=>(this.handleChromeMessage(e,t,o),!0))}handleKeyDown(e){if(this.modules.ui.isSelecting())if("Escape"===e.key)this.modules.ui.stopElementSelection();else if("Enter"===e.key&&this.modules.ui.getSelectedElement()){e.preventDefault(),e.stopPropagation();const t=this.modules.ui.getSelectedElement();this.modules.ui.stopElementSelection(),this.handleElementSelected(t)}}async handleChromeMessage(e,t,o){try{switch(e.action){case"startSelecting":this.startElementSelection(),o({success:!0});break;case"stopSelecting":this.stopElementSelection(),o({success:!0});break;case"convertFullPage":await this.convertFullPage(),o({success:!0});break;case"convertElement":e.selector&&await this.convertElementBySelector(e.selector),o({success:!0});break;case"convertMarkdown":e.markdown&&await this.convertMarkdown(e.markdown,e.format||"pdf"),o({success:!0});break;default:o({success:!1,error:"未知操作: "+e.action})}}catch(e){console.error("[MD2PDF] 处理消息失败:",e),o({success:!1,error:e.message})}}async handleElementSelected(e){if(e&&this.initialized)try{const t=this.modules.pdfConverter.shouldUseStandardMode();this.modules.ui.showLoading();try{await new Promise(e=>setTimeout(e,100)),t?await this.modules.pdfConverter.convertElementToPDF(e):await this.modules.pdfConverter.convertElementToPDFFast(e)}catch(e){console.error("[MD2PDF] 元素转换失败:",e)}finally{console.log("[MD2PDF] Reached finally block in handleElementSelected. Attempting to hide loading."),this.modules.ui.hideLoading()}}catch(e){console.error("[MD2PDF] 处理元素选择失败:",e)}}startElementSelection(){this.initialized&&this.modules.ui.startElementSelection()}stopElementSelection(){this.initialized&&this.modules.ui.stopElementSelection()}async convertFullPage(){if(!this.initialized)return;this.modules.pdfConverter.shouldUseStandardMode()?await this.modules.pdfConverter.convertElementToPDF(document.body):await this.modules.pdfConverter.convertElementToPDFFast(document.body)}async convertElementBySelector(e){if(!this.initialized)return;const t=document.querySelector(e);t&&await this.handleElementSelected(t)}async convertMarkdown(e,t="pdf"){this.initialized&&("word"===t?await this.modules.markdownConverter.convertMarkdownToWordOptimized(e):await this.modules.markdownConverter.convertMarkdownToPDFOptimized(e))}exposeGlobalAPI(){window.startSelecting=()=>this.startElementSelection(),window.stopSelecting=()=>this.stopElementSelection(),window.convertMarkdownStringToPDF=e=>this.modules.markdownConverter?.convertMarkdownStringToPDF(e),window.convertMarkdownToPDFOptimized=(e,t)=>this.modules.markdownConverter?.convertMarkdownToPDFOptimized(e,t),window.convertMarkdownToWordOptimized=(e,t)=>this.modules.markdownConverter?.convertMarkdownToWordOptimized(e,t),window.getMessage=(e,t)=>this.modules.utils?.getMessage(e,t)||e,window.md2pdfDebug={enable:()=>(console.log("[MD2PDF] 调试功能已简化，iframe始终隐藏"),!0),disable:()=>(console.log("[MD2PDF] 调试功能已简化，iframe始终隐藏"),!0),status:()=>(console.log("[MD2PDF] 调试功能已简化"),!1),test:()=>window.MD2PDF_PDFConverter&&window.MD2PDF_PDFConverter.debug?(window.MD2PDF_PDFConverter.debug.testContainer(),!0):(console.error("[MD2PDF] PDF转换器未加载"),!1),help:()=>{}},chrome.runtime.onMessage.addListener((e,t,o)=>{if("debugModeChanged"===e.action)console.log("[MD2PDF] 调试功能已简化，忽略调试模式变化");else{if("testDebugContainer"===e.action)return window.MD2PDF_PDFConverter&&window.MD2PDF_PDFConverter.debug?(window.MD2PDF_PDFConverter.debug.testContainer(),o({success:!0})):o({success:!1,error:"PDF转换器未加载"}),!0;if("checkDebugStatus"===e.action){return o({debugStatus:!(!window.StyleConfig||!window.StyleConfig.isDebugMode)&&window.StyleConfig.isDebugMode(),styleConfigLoaded:!!window.StyleConfig,pdfConverterLoaded:!!window.MD2PDF_PDFConverter}),!0}}})}getModuleStatus(){return{initialized:this.initialized,modules:{MD2PDF_Utils:!!window.MD2PDF_Utils,MD2PDF_UI:!!window.MD2PDF_UI,MD2PDF_PDFConverter:!!window.MD2PDF_PDFConverter,MD2PDF_MarkdownConverter:!!window.MD2PDF_MarkdownConverter,MD2PDF_Styles:!!window.MD2PDF_Styles,MD2PDF_I18N:!!window.MD2PDF_I18N}}}}window.MD2PDF||(window.MD2PDF=new MD2PDFController),"undefined"!=typeof module&&module.exports&&(module.exports=MD2PDFController);